<div>
    <div class="row align-items-center justify-content-between mb-4">
        <div class="col">
            <h5 class="fw-500 text-white"><?php echo e($lang->data['order_status_screen'] ?? 'Order Status Screen'); ?></h5>
        </div>
        <div class="col-auto">
            <a href="<?php echo e(route('admin.create_orders')); ?>" class="btn btn-icon btn-3 btn-white text-primary mb-0">
                <i class="fa fa-plus me-2"></i> <?php echo e($lang->data['add_new_order'] ?? 'Add New Order'); ?>

            </a>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card mb-4">
                <div class="scrum-board-container">
                    <div class="flex">
                        <div class="scrum-board pending">
                            <h5 class="text-uppercase text-secondary"><?php echo e($lang->data['pending'] ?? 'Pending'); ?></h5>
                            <div class="scrum-board-column" id="pending">
                                <?php $__currentLoopData = $pending_orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="<?php echo e(getOrderStatusWithColorKan($item->status)); ?> overflow"
                                        id="<?php echo e($item->id); ?>">
                                        <div class="d-flex justify-content-between mb-2">
                                            <div>
                                                <span
                                                    class="fw-600 ms-2 text-sm text-dark"><?php echo e($item->customer_name ?? ($lang->data['walk_in_customer'] ?? 'Walk In Customer')); ?></span>
                                                <div class="ms-2 mb-0">
                                                    <span
                                                        class="text-xs"><?php echo e($lang->data['delivery_date'] ?? 'Delivery Date'); ?>:</span>
                                                    <span
                                                        class="text-xs fw-600 ms-2"><?php echo e(\Carbon\Carbon::parse($item->delivery_date)->format('d/m/Y')); ?></span>
                                                </div>
                                            </div>
                                            <div><span
                                                    class="fw-600 text-dark text-sm me-2"><?php echo e($item->order_number); ?></span>
                                            </div>
                                        </div>
                                        <?php
                                            $services = \App\Models\OrderDetails::where('order_id', $item->id)
                                                ->limit(4)
                                                ->get();
                                        ?>
                                        <div class="pt-1 mb-0">
                                            <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $service = \App\Models\Service::where('id', $row->service_id)->first();
                                                ?>
                                                <a class="avatar avatar-sm ms-2 p-1 bg-light">
                                                    <img src="<?php echo e(asset('assets/img/service-icons/' . $service->icon)); ?>">
                                                </a>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                        <div class="scrum-board-processing processing">
                            <h5 class="text-uppercase text-warning"><?php echo e($lang->data['processing'] ?? 'Processing'); ?>

                            </h5>
                            <div class="scrum-board-column" id="processing">
                                <?php $__currentLoopData = $processing_orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="<?php echo e(getOrderStatusWithColorKan($item->status)); ?> overflow"
                                        id="<?php echo e($item->id); ?>">
                                        <div class="d-flex justify-content-between mb-2">
                                            <div>
                                                <span
                                                    class="fw-600 text-sm ms-2 text-dark"><?php echo e($item->customer_name ?? ($lang->data['walk_in_customer'] ?? 'Walk In Customer')); ?></span>
                                                <div class="ms-2 mb-0">
                                                    <span
                                                        class="text-xs"><?php echo e($lang->data['delivery_date'] ?? 'Delivery Date'); ?>:</span>
                                                    <span
                                                        class="text-xs fw-600 ms-2"><?php echo e(\Carbon\Carbon::parse($item->delivery_date)->format('d/m/Y')); ?></span>
                                                </div>
                                            </div>
                                            <div><span
                                                    class="fw-600 text-sm text-dark me-2"><?php echo e($item->order_number); ?></span>
                                            </div>
                                        </div>
                                        <?php
                                            $services = \App\Models\OrderDetails::where('order_id', $item->id)
                                                ->limit(4)
                                                ->get();
                                        ?>
                                        <div class="pt-1 mb-0">
                                            <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $service = \App\Models\Service::where('id', $row->service_id)->first();
                                                ?>
                                                <a class="avatar avatar-sm ms-2 p-1 bg-light">
                                                    <img src="<?php echo e(asset('assets/img/service-icons/' . $service->icon)); ?>">
                                                </a>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                        <div class="scrum-board ready">
                            <h5 class="text-uppercase text-success">
                                <?php echo e($lang->data['ready_to_deliver'] ?? 'Ready To Deliver'); ?></h5>
                            <div class="scrum-board-column" id="ready">
                                <?php $__currentLoopData = $ready_orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="<?php echo e(getOrderStatusWithColorKan($item->status)); ?> overflow"
                                        id="<?php echo e($item->id); ?>">
                                        <div class="d-flex justify-content-between mb-2">
                                            <div>
                                                <span
                                                    class="fw-600 ms-2 text-sm text-dark"><?php echo e($item->customer_name ?? ($lang->data['walk_in_customer'] ?? 'Walk In Customer')); ?></span>
                                                <div class="ms-2 mb-0">
                                                    <span
                                                        class="text-xs"><?php echo e($lang->data['delivery_date'] ?? 'Delivery Date'); ?>:</span>
                                                    <span
                                                        class="text-xs fw-600 ms-2"><?php echo e(\Carbon\Carbon::parse($item->delivery_date)->format('d/m/Y')); ?></span>
                                                </div>
                                            </div>
                                            <div><span
                                                    class="fw-600 text-sm text-dark me-2"><?php echo e($item->order_number); ?></span>
                                            </div>
                                        </div>
                                        <?php
                                            $services = \App\Models\OrderDetails::where('order_id', $item->id)
                                                ->limit(4)
                                                ->get();
                                        ?>
                                        <div class="pt-1 mb-0">
                                            <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $service = \App\Models\Service::where('id', $row->service_id)->first();
                                                ?>
                                                <a class="avatar avatar-sm ms-2 p-1 bg-light">
                                                    <img src="<?php echo e(asset('assets/img/service-icons/' . $service->icon)); ?>">
                                                </a>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php $__env->startPush('js'); ?>
        <script>
             "use strict";
            var drake = dragula([document.querySelector('#ready'), document.querySelector('#processing'), document
                .querySelector('#pending')
            ]);
            drake.on("drop", function(el, target, source, sibling) {

                window.livewire.find('<?php echo e($_instance->id); ?>').changestatus(el.id, target.id);
            });
        </script>
    <?php $__env->stopPush(); ?>
</div><?php /**PATH /home/charter2/test.charteredadjusters.co.ke/resources/views/livewire/admin/orders/order-status-screen.blade.php ENDPATH**/ ?>