<div>
<div class="row align-items-center justify-content-between mb-4">
    <div class="col">
        <h5 class="fw-500 text-white"><?php echo e($lang->data['services'] ?? 'Services'); ?></h5>
    </div>
    <div class="col-auto">
        <a href="<?php echo e(route('admin.service_create')); ?>" class="btn btn-icon btn-3 btn-white text-primary mb-0">
            <i class="fa fa-plus me-2"></i> <?php echo e($lang->data['add_new_service'] ?? 'Add New Service'); ?>

        </a>
    </div>
</div>
<div class="row">
    <div class="col-12">
        <div class="card mb-4">
            <div class="card-header p-4">
                <div class="row">
                    <div class="col-md-12">
                        <input type="text" class="form-control" placeholder="<?php echo e($lang->data['search_here'] ?? 'Search Here'); ?>" wire:model="search_query">
                    </div>
                </div>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table align-items-center mb-0">
                        <thead class="bg-light">
                            <tr>
                                <th class="text-uppercase text-secondary text-xs opacity-7">#</th>
                                <th class="text-uppercase text-secondary text-xs opacity-7"><?php echo e($lang->data['service_name'] ?? 'Service Name'); ?></th>
                                <th class="text-center text-uppercase text-secondary text-xs opacity-7"><?php echo e($lang->data['service_types'] ?? 'Service Types'); ?></th>
                                <th class="text-center text-uppercase text-secondary text-xs  opacity-7"><?php echo e($lang->data['status'] ?? 'Status'); ?></th>
                                <th class="text-secondary opacity-7"></th>
                            </tr>
                        </thead>
                        
                        <tbody>
                            <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <p class="text-sm px-3 mb-0"><?php echo e($loop->index+1); ?></p>
                                </td>
                                <td>
                                    <div class="d-flex px-3 py-1">
                                        <div>
                                            <img src="<?php echo e(asset('assets/img/service-icons/'.$item->icon)); ?>" class="avatar avatar-sm me-3">
                                        </div>
                                        <div class="d-flex flex-column justify-content-center">
                                            <h6 class="mb-0 text-sm"><?php echo e($item->service_name); ?></h6>
                                        </div>
                                    </div>
                                </td>
                                <td class="align-middle text-center">
                                    <?php
                                        $details = \App\Models\ServiceDetail::where('service_id',$item->id)->get();
                                    ?>
                                    <?php if($details): ?>
                                    <?php $__currentLoopData = $details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $type = \App\Models\ServiceType::where('id',$row->service_type_id)->first();
                                        ?>
                                    <span class="badge badge-sm bg-dark rounded-pill fw-500"><?php echo e($type->service_type_name); ?></span>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </td>
                                <td class="align-middle text-center">
                                    <?php if($item->is_active == 1): ?>
                                    <a type="button" class="badge badge-sm bg-success"><?php echo e($lang->data['active'] ?? 'Active'); ?></a>
                                    <?php else: ?> 
                                    <a type="button" class="badge badge-sm bg-danger"><?php echo e($lang->data['inactive'] ?? 'InActive'); ?></a>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('admin.service_edit',$item->id)); ?>"  type="button" class="badge badge-xs badge-warning fw-600 text-xs">
                                        <?php echo e($lang->data['edit'] ?? 'Edit'); ?>

                                    </a>
                                    <a href="#" wire:click="delete(<?php echo e($item->id); ?>)"  type="button" class="ms-2 badge badge-xs badge-danger text-xs fw-600">
                                        <?php echo e($lang->data['delete'] ?? 'Delete'); ?>

                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    
            </div>
        </div>
    </div>
</div>
</div><?php /**PATH /home/charter2/test.charteredadjusters.co.ke/resources/views/livewire/admin/service/service-list.blade.php ENDPATH**/ ?>