<div>
    <div class="row align-items-center justify-content-between mb-4">
        <div class="col">
            <h5 class="fw-500 text-white"><?php echo e($lang->data['customers'] ?? 'Customers'); ?></h5>
        </div>
        <div class="col-auto">
            <a data-bs-toggle="modal" data-bs-target="#addcustomer" wire:click="resetInputFields"
                class="btn btn-icon btn-3 btn-white text-primary mb-0">
                <i class="fa fa-plus me-2"></i> <?php echo e($lang->data['add_new_customer'] ?? 'Add New Customer'); ?>

            </a>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card mb-4">
                <div class="card-header p-4">
                    <div class="row">
                        <div class="col-md-12">
                            <input type="text" class="form-control"
                                placeholder="<?php echo e($lang->data['search_here'] ?? 'Search Here'); ?>" wire:model="search">
                        </div>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table align-items-center mb-0">
                            <thead class="bg-light">
                                <tr>
                                    <th class="text-uppercase text-secondary text-xs opacity-7">#</th>
                                    <th class="text-uppercase text-secondary text-xs opacity-7 ps-2">
                                        <?php echo e($lang->data['customer_name'] ?? 'Customer Name'); ?></th>
                                    <th class="text-uppercase text-secondary text-xs  opacity-7">
                                        <?php echo e($lang->data['contact'] ?? 'Contact'); ?></th>
                                    <th class="text-uppercase text-secondary text-xs opacity-7 ps-2">
                                        <?php echo e($lang->data['address'] ?? 'Address'); ?></th>
                                    <th class="text-secondary opacity-7"></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    $i = 1;
                                ?>
                                <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <p class="text-sm px-3 mb-0"><?php echo e($i++); ?></p>
                                        </td>
                                        <td>
                                            <p class="text-sm font-weight-bold mb-0"><?php echo e($row->name); ?></p>
                                        </td>
                                        <td>
                                            <p class="text-sm px-3 mb-0"><?php echo e($row->phone); ?></p>
                                            <p class="text-sm px-3 mb-0"><?php echo e($row->email); ?></p>
                                        </td>
                                        <td>
                                            <p class="text-sm mb-0"><?php echo e($row->address); ?></p>
                                        </td>
                                        <td>
                                            <a data-bs-toggle="modal" data-bs-target="#editcustomer"
                                                wire:click="edit(<?php echo e($row->id); ?>)" type="button"
                                                class="badge badge-xs badge-warning fw-600 text-xs">
                                                <?php echo e($lang->data['edit'] ?? 'Edit'); ?>

                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        <?php if($hasMorePages): ?>
                        <div
                            x-data="{
                                init () {
                                    let observer = new IntersectionObserver((entries) => {
                                        entries.forEach(entry => {
                                            if (entry.isIntersecting) {
                                                window.livewire.find('<?php echo e($_instance->id); ?>').call('loadCustomers')
                                                console.log('loading...')
                                            }
                                        })
                                    }, {
                                        root: null
                                    });
                                    observer.observe(this.$el);
                                }
                            }"
                            class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8 mt-4"
                        >
                           <div class="text-center pb-2 d-flex justify-content-center align-items-center">
                               Loading...
                               <div class="spinner-grow d-inline-flex mx-2 text-primary" role="status">
                                <span class="visually-hidden">Loading...</span>
                              </div>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div wire:ignore.self class="modal fade " id="addcustomer" tabindex="-1" role="dialog"
        aria-labelledby="addcustomer" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h6 class="modal-title fw-600" id="addcustomer"><?php echo e($lang->data['add_customer'] ?? 'Add Customer'); ?>

                    </h6>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form>
                    <div class="modal-body">
                        <div class="row g-2 align-items-center">
                            <div class="col-md-12 mb-1">
                                <label class="form-label"><?php echo e($lang->data['customer_name'] ?? 'Customer Name'); ?>

                                    <span class="text-danger">*</span></label>
                                <input type="text" required class="form-control"
                                    placeholder="<?php echo e($lang->data['enter_customer_name'] ?? 'Enter Customer Name'); ?>"
                                    wire:model="name">
                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-12 mb-1">
                                <label class="form-label"><?php echo e($lang->data['phone_number'] ?? 'Phone Number'); ?> <span
                                        class="text-danger">*</span></label>
                                <input type="text" required class="form-control"
                                    placeholder="<?php echo e($lang->data['enter_phone_number'] ?? 'Enter Phone Number'); ?>"
                                    wire:model="phone">
                                <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-12 mb-1">
                                <label class="form-label"><?php echo e($lang->data['email'] ?? 'Email'); ?></label>
                                <input type="text" class="form-control"
                                    placeholder="<?php echo e($lang->data['enter_email'] ?? 'Enter Email'); ?>" wire:model="email">
                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-12 mb-1">
                                <label class="form-label"><?php echo e($lang->data['tax_number'] ?? 'Tax Number'); ?></label>
                                <input type="text" class="form-control"
                                    placeholder="<?php echo e($lang->data['enter_tax_number'] ?? 'Enter Tax Number'); ?>"
                                    wire:model="tax_number">
                                <?php $__errorArgs = ['tax_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-12 mb-3">
                                <label class="form-label"><?php echo e($lang->data['address'] ?? 'Address'); ?></label>
                                <textarea type="text" class="form-control"
                                    placeholder="<?php echo e($lang->data['enter_address'] ?? 'Enter Address'); ?>"
                                    wire:model="address"></textarea>
                                <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-12 mb-1">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="employee" checked
                                        wire:model="is_active">
                                    <label class="form-check-label"
                                        for="employee"><?php echo e($lang->data['is_active'] ?? 'Is Active'); ?> ?</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                            data-bs-dismiss="modal"><?php echo e($lang->data['cancel'] ?? 'Cancel'); ?></button>
                        <button type="submit" class="btn btn-primary"
                            wire:click.prevent="store()"><?php echo e($lang->data['save'] ?? 'Save'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="modal fade" wire:ignore.self id="editcustomer" tabindex="-1" role="dialog"
        aria-labelledby="editcustomer" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h6 class="modal-title fw-600" id="editcustomer">
                        <?php echo e($lang->data['enter_customer'] ?? 'Enter Customer'); ?></h6>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form>
                    <div class="modal-body">
                        <div class="row g-2 align-items-center">
                            <div class="col-md-12 mb-1">
                                <label class="form-label"><?php echo e($lang->data['customer_name'] ?? 'Customer Name'); ?>

                                    <span class="text-danger">*</span></label>
                                <input type="text" required class="form-control"
                                    placeholder="<?php echo e($lang->data['enter_customer_name'] ?? 'Enter Customer Name'); ?>"
                                    wire:model="name">
                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-12 mb-1">
                                <label class="form-label"><?php echo e($lang->data['phone_number'] ?? 'Phone Number'); ?> <span
                                        class="text-danger">*</span></label>
                                <input type="text" required class="form-control"
                                    placeholder="<?php echo e($lang->data['enter_phone_number'] ?? 'Enter Phone Number'); ?>"
                                    wire:model="phone">
                                <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-12 mb-1">
                                <label class="form-label"><?php echo e($lang->data['email'] ?? 'Email'); ?></label>
                                <input type="text" class="form-control"
                                    placeholder="<?php echo e($lang->data['enter_email'] ?? 'Enter Email'); ?>" wire:model="email">
                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-12 mb-1">
                                <label class="form-label"><?php echo e($lang->data['tax_number'] ?? 'Tax Number'); ?></label>
                                <input type="text" class="form-control"
                                    placeholder="<?php echo e($lang->data['enter_tax_number'] ?? 'Enter Tax Number'); ?>"
                                    wire:model="tax_number">
                                <?php $__errorArgs = ['tax_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-12 mb-3">
                                <label class="form-label"><?php echo e($lang->data['address'] ?? 'Address'); ?></label>
                                <textarea type="text" class="form-control"
                                    placeholder="<?php echo e($lang->data['enter_address'] ?? 'Enter Address'); ?>"
                                    wire:model="address"></textarea>
                                <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-12 mb-1">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="employee" checked
                                        wire:model="is_active">
                                    <label class="form-check-label"
                                        for="employee"><?php echo e($lang->data['is_active'] ?? 'Is Active'); ?> ?</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                            data-bs-dismiss="modal"><?php echo e($lang->data['cancel'] ?? 'Cancel'); ?></button>
                        <button type="submit" class="btn btn-primary"
                            wire:click.prevent="update()"><?php echo e($lang->data['save'] ?? 'Save'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div><?php /**PATH /home/charter2/test.charteredadjusters.co.ke/resources/views/livewire/admin/customers/customers.blade.php ENDPATH**/ ?>