<div>
    <div class="row align-items-center justify-content-between mb-4">
        <div class="col">
            <h5 class="fw-500 text-white"><?php echo e($lang->data['order_details'] ?? 'Order Details'); ?></h5>
        </div>
        <div class="col-auto">
            <a href="<?php echo e(route('admin.view_orders')); ?>" class="btn btn-icon btn-3 btn-white text-primary mb-0">
                <i class="fa fa-arrow-left me-2"></i> <?php echo e($lang->data['back'] ?? 'Back'); ?>

            </a>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-9">
            <div class="card mb-4">
                <div class="card-header p-4">
                    <div class="row align-items-center">
                        <div class="col">
                            <h5 class="text-uppercase fw-500"><?php echo e($sitename); ?></h5>
                            <p class="text-sm mb-0"><?php echo e($phone); ?></p>
                            <p class="text-sm mb-0"><?php echo e($store_email); ?></p>
                            <p class="text-sm mb-3"><?php echo e($address); ?> - <?php echo e($zipcode); ?></p>
                            <p class="text-sm mb-0 text-uppercase"> <?php echo e($lang->data['tax'] ?? 'TAX'); ?>:
                                <?php echo e($tax_number); ?></p>
                        </div>
                        <div class="col-auto mt-4">
                            <h6 class="text-uppercase fw-500">
                                <span> <?php echo e($lang->data['order_id'] ?? 'Order ID'); ?>:</span>
                                <span class="ms-2 fw-600">#<?php echo e($order->order_number); ?></span>
                            </h6>
                            <p class="text-sm mb-1">
                                <span> <?php echo e($lang->data['order_date'] ?? 'Order Date'); ?>:</span>
                                <span
                                    class="fw-600 ms-2"><?php echo e(\Carbon\Carbon::parse($order->order_date)->format('d/m/Y')); ?></span>
                            </p>
                            <p class="text-sm mb-3">
                                <span> <?php echo e($lang->data['delivery_date'] ?? 'Delivery Date'); ?>:</span>
                                <span
                                    class="fw-600 ms-2"><?php echo e(\Carbon\Carbon::parse($order->delivery_date)->format('d/m/Y')); ?></span>
                            </p>
                            <div class="d-flex align-items-center">
                                <div><span class="text-sm">
                                        <?php echo e($lang->data['order_status'] ?? 'Order Status'); ?>:</span></div>
                                <div class="dropdown ms-2">
                                    <button class="btn btn-xs bg-secondary dropdown-toggle mb-0 text-white"
                                        type="button" id="dropdownMenuButton" data-bs-toggle="dropdown"
                                        aria-expanded="false">
                                        <?php echo e(getOrderStatus($order->status)); ?>

                                    </button>
                                    <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                        <li><a class="dropdown-item" href="#"
                                                wire:click.prevent="changeStatus(1)"><?php echo e($lang->data['processing'] ?? 'Processing'); ?></a>
                                        </li>
                                        <li><a class="dropdown-item" href="#"
                                                wire:click.prevent="changeStatus(2)"><?php echo e($lang->data['ready_to_deliver'] ?? 'Ready To Deliver'); ?></a>
                                        </li>
                                        <li><a class="dropdown-item" href="#"
                                                wire:click.prevent="changeStatus(3)"><?php echo e($lang->data['delivered'] ?? 'Delivered'); ?></a>
                                        </li>
                                        <li><a class="dropdown-item" href="#"
                                                wire:click.prevent="changeStatus(4)"><?php echo e($lang->data['returned'] ?? 'Returned'); ?></a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table align-items-center mb-0">
                            <thead class="bg-light">
                                <tr>
                                    <th class="text-uppercase text-secondary text-xs opacity-7">#</th>
                                    <th class="text-uppercase text-secondary text-xs opacity-7">
                                        <?php echo e($lang->data['service_name'] ?? 'Service Name'); ?></th>
                                    <th class="text-uppercase text-secondary text-xs opacity-7">
                                        <?php echo e($lang->data['color'] ?? 'Color'); ?></th>
                                    <th class="text-uppercase text-secondary text-xs opacity-7">
                                        <?php echo e($lang->data['rate'] ?? 'Rate'); ?></th>
                                    <th class="text-center text-uppercase text-secondary text-xs  opacity-7">
                                        <?php echo e($lang->data['qty'] ?? 'QTY'); ?></th>
                                    <th class="text-uppercase text-secondary text-xs opacity-7">
                                        <?php echo e($lang->data['total'] ?? 'Total'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $orderdetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $service = \App\Models\Service::where('id', $item->service_id)->first();
                                    ?>
                                    <tr>
                                        <td>
                                            <p class="text-sm px-3 mb-0"><?php echo e($loop->index + 1); ?></p>
                                        </td>
                                        <td>
                                            <div class="d-flex px-3 py-1">
                                                <div>
                                                    <img src="<?php echo e(asset('assets/img/service-icons/' . $service->icon)); ?>"
                                                        class="avatar avatar-sm me-3">
                                                </div>
                                                <div class="d-flex flex-column justify-content-center">
                                                    <h6 class="mb-1 text-sm"><?php echo e($service->service_name); ?></h6>
                                                    <span
                                                        class="text-xs fw-600 text-primary">[<?php echo e($item->service_name); ?>]</span>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="px-4">
                                            <?php if($item->color_code!=""): ?>
                                                <button class="btn" style="background-color: <?php echo e($item->color_code); ?>">
                                                </button>
                                            <?php endif; ?>
                                        </td>
                                        <td class="">
                                            <p class="text-sm px-3 mb-0"><?php echo e(getCurrency()); ?>

                                                <?php echo e(number_format($item->service_price, 2)); ?></p>
                                        </td>
                                        <td class="align-middle text-center">
                                            <p class="text-sm px-3 mb-0"><?php echo e($item->service_quantity); ?></p>
                                        </td>
                                        <td class="">
                                            <p class="text-sm px-3 mb-0"><?php echo e(getCurrency()); ?>

                                                <?php echo e(number_format($item->service_detail_total, 2)); ?></p>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <hr class="mb-0 mt-0 bg-secondary">
                <div class="card-footer px-4">
                    <div class="row">
                        <div class="col-md-8 mb-3">
                            <h6 class="mb-2 fw-500"><?php echo e($lang->data['invoice_to'] ?? 'Invoice To'); ?>:</h6>
                            <h6 class="mb-1 fw-500 text-sm"><?php echo e($customer->name ?? 'Walk-In Customer'); ?></h6>
                            <p class="text-sm mb-0"><?php echo e($customer->phone ?? 'Phone'); ?></p>
                            <p class="text-sm mb-0"><?php echo e($customer->email ?? 'Email'); ?></p>
                            <p class="text-sm mb-3"><?php echo e($customer->address ?? 'Customer'); ?></p>
                            <p class="text-sm mb-0"><?php echo e($lang->data['vat'] ?? 'VAT'); ?>:
                                <?php echo e($customer->tax_number ?? 'TAX'); ?></p>
                        </div>
                        <div class="col-md-4 mb-3">
                            <h6 class="fw-500 mb-2"><?php echo e($lang->data['payment_details'] ?? 'Payment Details'); ?>:
                            </h6>
                            <div class="">
                                <div class="row mb-50 align-items-center">
                                    <div class="col text-sm"><?php echo e($lang->data['sub_total'] ?? 'Sub Total'); ?>:</div>
                                    <div class="col-auto text-sm"><?php echo e(getCurrency()); ?>

                                        <?php echo e(number_format($order->sub_total, 2)); ?></div>
                                </div>
                                <div class="row mb-50 align-items-center">
                                    <div class="col text-sm"><?php echo e($lang->data['addon'] ?? 'Addon'); ?>:</div>
                                    <div class="col-auto text-sm"><?php echo e(getCurrency()); ?>

                                        <?php echo e(number_format($order->addon_total, 2)); ?></div>
                                </div>
                                <div class="row mb-50 align-items-center">
                                    <div class="col text-sm"><?php echo e($lang->data['discount'] ?? 'Discount'); ?>:</div>
                                    <div class="col-auto text-sm"><?php echo e(getCurrency()); ?>

                                        <?php echo e(number_format($order->discount, 2)); ?></div>
                                </div>
                                <div class="row mb-3 align-items-center">
                                    <div class="col text-sm"><?php echo e($lang->data['tax'] ?? 'Tax'); ?>

                                        (<?php echo e($order->tax_percentage); ?>%):</div>
                                    <div class="col-auto text-sm"><?php echo e(getCurrency()); ?>

                                        <?php echo e(number_format($order->tax_amount, 2)); ?></div>
                                </div>
                                <div class="row align-items-center">
                                    <div class="col text-sm fw-600">
                                        <?php echo e($lang->data['gross_total'] ?? 'Gross Total'); ?>:
                                    </div>
                                    <div class="col-auto text-sm text-dark fw-600"><?php echo e(getCurrency()); ?>

                                        <?php echo e(number_format($order->total, 2)); ?></div>
                                </div>
                            </div>
                        </div>
                        <hr class="bg-secondary">
                        <div class="col-md-1">
                            <h6 class="mb-2 text-sm fw-500"><?php echo e($lang->data['notes'] ?? 'Notes'); ?>:</h6>
                        </div>
                        <div class="col-md-11">
                            <p class="text-sm mb-0"><?php echo e($order->note); ?></p>
                        </div>
                        <div class="mt-4 position-relative text-center">
                            <p class="text-sm fw-500 mb-2 text-secondary text-border d-inline z-index-2 bg-white px-3">
                                Powered by <a href="<?php echo e(url('/')); ?>" class="text-dark fw-600" target="_blank"><?php echo e(getApplicationName()); ?></a>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-3">
            <div class="card mb-4">
                <div class="card-body p-4">
                    <?php if($orderaddons): ?>
                        <?php if(count($orderaddons) > 0): ?>
                            <h6 class="mb-3 fw-500 mt-2"><?php echo e($lang->data['service_addons'] ?? 'Service Addons'); ?></h6>
                            <ul class="list-group">
                                <li class="list-group-item border-0 d-flex p-4 mb-2 bg-gray-100 border-radius-lg">
                                    <div class="d-flex flex-column">
                                        <?php $__currentLoopData = $orderaddons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span class="mb-3 text-sm">
                                                <span class="fw-500"><?php echo e($item->addon_name); ?>:</span>
                                                <span class="text-sm ms-2"><?php echo e(getCurrency()); ?>

                                                    <?php echo e(number_format($item->addon_price, 2)); ?></span>
                                            </span>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </li>
                            </ul>
                        <?php endif; ?>
                    <?php endif; ?>
                    <h6 class="mb-3 fw-500 mt-2"><?php echo e($lang->data['payments'] ?? 'Payments'); ?></h6>
                    <div class="timeline timeline-one-side">
                        <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="timeline-block mb-3">
                                <span class="timeline-step">
                                    <i class="fa fa-dot-circle-o text-secondary"></i>
                                </span>
                                <div class="timeline-content">
                                    <h6 class="text-dark text-sm font-weight-bold mb-0"><?php echo e(getCurrency()); ?>

                                        <?php echo e(number_format($item->received_amount, 2)); ?></h6>
                                    <p class="text-secondary text-xs mt-1 mb-0">
                                        <span><?php echo e(Carbon\Carbon::parse($item->payment_date)->format('d/m/Y')); ?></span>
                                        <span
                                            class="ms-2 fw-600 text-uppercase">[<?php echo e(getpaymentMode($item->payment_type)); ?>]</span>
                                    </p>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <div class="row">
                        <?php if($balance > 0): ?>
                            <?php if($order->status != 4): ?>
                            <div class="col-12">
                                <a data-bs-toggle="modal" data-bs-target="#addpayment" type="button"
                                    class="badge badge-success mb-3 w-100 py-3 fw-600">
                                    <?php echo e($lang->data['add_payment'] ?? 'Add Payment'); ?>

                                </a>
                            </div>
                            <?php endif; ?>
                        <?php else: ?>
                            <div class="col-12">
                                <a type="button" class="badge badge-light disabled mb-3 w-100 py-3 fw-600">
                                    <?php echo e($lang->data['fully_paid'] ?? 'Fully Paid'); ?>

                                </a>
                            </div>
                        <?php endif; ?>
                        <div class="col-12">
                            <a href="<?php echo e(url('admin/orders/print-order/' . $order->id)); ?>" target="_blank"
                                type="button" class="btn btn-icon btn-warning mb-0 w-100">
                                <?php echo e($lang->data['print_invoice'] ?? 'Print Invoice'); ?>

                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade " id="image" tabindex="-1" role="dialog" aria-labelledby="image" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h6 class="modal-title fw-600" id="image"><?php echo e($lang->data['image'] ?? 'Image'); ?></h6>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row g-3 align-items-center">
                        <div class="col-md-12">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary"
                        data-bs-dismiss="modal"><?php echo e($lang->data['close'] ?? 'Close'); ?></button>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade " id="addpayment" tabindex="-1" role="dialog" aria-labelledby="addpayment"
        aria-hidden="true" wire:ignore.self>
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h6 class="modal-title fw-600" id="addpayment">
                        <?php echo e($lang->data['payment_details'] ?? 'Payment Details'); ?></h6>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form>
                    <div class="modal-body">
                        <div class="row g-2 align-items-center">
                            <div class=" col-12">
                                <div class="row mb-50 align-items-center">
                                    <div class="col text-sm fw-500">
                                        <?php echo e($lang->data['customer_name'] ?? 'Customer Name'); ?>:</div>
                                    <div class="col-auto text-sm fw-500"><?php echo e($customer->name ?? ''); ?></div>
                                </div>
                                <div class="row mb-50 align-items-center">
                                    <div class="col text-sm fw-500"><?php echo e($lang->data['order_id'] ?? 'Order ID'); ?>:
                                    </div>
                                    <div class="col-auto text-sm fw-500"><?php echo e($order->order_number); ?></div>
                                </div>
                                <div class="row mb-50 align-items-center">
                                    <div class="col text-sm fw-500"><?php echo e($lang->data['order_date'] ?? 'Order Date'); ?>:
                                    </div>
                                    <div class="col-auto  text-sm fw-500">
                                        <?php echo e(\Carbon\Carbon::parse($order->order_date)->format('d/m/Y')); ?></div>
                                </div>
                                <div class="row mb-50 align-items-center">
                                    <div class="col text-sm fw-500">
                                        <?php echo e($lang->data['delivery_date'] ?? 'Delivery Date'); ?>:</div>
                                    <div class="col-auto  text-sm fw-500">
                                        <?php echo e(\Carbon\Carbon::parse($order->delivery_date)->format('d/m/Y')); ?></div>
                                </div>
                                <hr>
                                <div class="row mb-50 align-items-center">
                                    <div class="col text-sm fw-500">
                                        <?php echo e($lang->data['order_amount'] ?? 'Order Amount'); ?>:</div>
                                    <div class="col-auto  text-sm fw-500"><?php echo e(getCurrency()); ?>

                                        <?php echo e(number_format($order->total, 2)); ?></div>
                                </div>
                                <div class="row mb-50 align-items-center">
                                    <div class="col text-sm fw-500">
                                        <?php echo e($lang->data['paid_amount'] ?? 'Paid Amount'); ?>:
                                    </div>
                                    <div class="col-auto text-sm fw-500"><?php echo e(getCurrency()); ?>

                                        <?php echo e(number_format($order->total - $balance, 2)); ?></div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col text-sm fw-600"><?php echo e($lang->data['balance'] ?? 'Balance'); ?>:</div>
                                    <div class="col-auto text-sm fw-600"><?php echo e(getCurrency()); ?>

                                        <?php echo e(number_format($balance, 2)); ?></div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-md-6 mb-1">
                                        <label
                                            class="form-label"><?php echo e($lang->data['paid_amount'] ?? 'Paid Amount'); ?></label>
                                        <input type="number" class="form-control"
                                            placeholder="<?php echo e($lang->data['enter_amount'] ?? 'Enter Amount'); ?>"
                                            wire:model="paid_amount">
                                    </div>
                                    <div class="col-md-6 mb-1">
                                        <label
                                            class="form-label"><?php echo e($lang->data['payment_type'] ?? 'Payment Type'); ?></label>
                                        <select class="form-select" wire:model="payment_type">
                                            <option value="">
                                                <?php echo e($lang->data['choose_payment_type'] ?? 'Choose Payment Type'); ?>

                                            </option>
                                            <option class="select-box" value="1">
                                                <?php echo e($lang->data['cash'] ?? 'Cash'); ?></option>
                                            <option class="select-box" value="2">
                                                <?php echo e($lang->data['upi'] ?? 'MPESA'); ?></option>
                                        </select>
                                    </div>
                                    <?php $__errorArgs = ['payment_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    <?php $__errorArgs = ['paid_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                            data-bs-dismiss="modal"><?php echo e($lang->data['cancel'] ?? 'Cancel'); ?></button>
                        <button type="button" class="btn btn-primary"
                            wire:click.prevent="addPayment"><?php echo e($lang->data['save'] ?? 'Save'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div><?php /**PATH /home/charter2/demo.charteredadjusters.co.ke/resources/views/livewire/admin/orders/view-single-order.blade.php ENDPATH**/ ?>